<?xml version="1.0" encoding="UTF-8"?><!--
            Copyright
            2010 axYus - http://www.axyus.com
            2010 J.Leger - johann.leger@axyus.com

            This file is part of ODM print-comp.

            ODM print-comp is free software; you can redistribute it and/or modify
            it under the terms of the GNU Lesser General Public License as published by
            the Free Software Foundation; either version 2 of the License, or
            (at your option) any later version.

            ODM print-comp is distributed in the hope that it will be useful,
            but WITHOUT ANY WARRANTY; without even the implied warranty of
            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
            GNU Lesser General Public License for more details.

            You should have received a copy of the GNU Lesser General Public License
            along with ODM print-comp; if not, write to the Free Software
            Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
        --><xsl:stylesheet xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"></xsl:import><xsl:import href="../../../../date.xsl"></xsl:import><xsl:import href="../../../../table.xsl"></xsl:import><xsl:import href="../../../../style.xsl"></xsl:import><xsl:import href="../../../../lien.xsl"></xsl:import><xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param><xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param><xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/EDDS"></xsl:variable><xsl:param name="nomenclaturePasEnrichie"></xsl:param><xsl:variable name="nomenclature" select="$nomenclaturePasEnrichie/n:Nomenclature"></xsl:variable><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"></xsl:variable><xsl:variable name="isPrint" select="1"></xsl:variable><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="*"></xsl:template><xsl:template match="EDDS"><html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
   <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><meta name="generator" content="ODM" />
      
      <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
      <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
      
      <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:SimSun;
  panose-1:2 1 6 0 3 1 1 1 1 1;}
@font-face
  {font-family:Mangal;
  panose-1:0 0 4 0 0 0 0 0 0 0;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:"Liberation Serif";
  panose-1:2 2 6 3 5 4 5 2 3 4;}
@font-face
  {font-family:"\@SimSun";
  panose-1:2 1 6 0 3 1 1 1 1 1;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  text-autospace:ideograph-other;
  font-size:12.0pt;
  font-family:"Liberation Serif",serif;}
p.Standard, li.Standard, div.Standard
  {
  margin:0cm;
  text-autospace:ideograph-other;
  font-size:12.0pt;
  font-family:"Liberation Serif",serif;}
p.TableContents, li.TableContents, div.TableContents
  {
  margin:0cm;
  text-autospace:ideograph-other;
  font-size:12.0pt;
  font-family:"Liberation Serif",serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:297mm 210mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style></head>
   <body lang="FR" style="word-wrap:break-word"><div id="header">
         <div align="center">
            <xsl:variable name="varOdmTmpTab1"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse"><tr><td width="75.8%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1"><p style="line-height:115%;punctuation-wrap:simple;word-break: break-all"><span style="font-size:10.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                           <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@Codique)"/> – 
                           
                           
                           <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@LibellePoste)"/></span></p></td><td width="24.2%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1"><p align="right" style="text-align:right;line-height:115%; punctuation-wrap:simple;word-break:break-all"><span style="font-size:10.0pt; line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Date édition :
                           
                           
                           <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/EnteteComptable/Infos/Edition/@DateEdition)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param></xsl:call-template>
         </div>
         <p class="MsoNormal"><span style="font-size:4.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
      </div><xsl:variable name="eltsBoucleEtat" select="$docbudg/Budget/Compte/@NumCompte"></xsl:variable><xsl:choose><xsl:when test="count($eltsBoucleEtat)=0"><p class="normalText">Cet état ne contient pas d'information.</p></xsl:when><xsl:otherwise><xsl:for-each select="$eltsBoucleEtat"><xsl:sort select="."></xsl:sort><xsl:variable name="codeBoucleEtat" select="."></xsl:variable><xsl:if test="position() &gt; 1"><div style="page-break-before : always;"></div></xsl:if><xsl:variable name="varOdm1" select="$docbudg/Budget/Compte[(./@NumCompte=$codeBoucleEtat)]/LigneEDDS"/>
      
      <div class="WordSection1">
         <xsl:variable name="varOdmTmpTab2"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><thead>
               <tr><td width="100%" colspan="2" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="center" style="text-align:center"><b><span style="font-size:11.0pt;font-family:&#34;Arial&#34;,sans-serif">État de Développement des Soldes<br clear="none" />
                              du compte <xsl:value-of select="distinct-values($codeBoucleEtat)"/><br clear="none" /></span></b><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif">à la date du <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/Budget/Compte[(./@NumCompte=$codeBoucleEtat) and (./@NumCompte=$codeBoucleEtat)]/@DateArrete)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p><p align="center" style="text-align:center"><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif;color:black; background:white">actualisée à la date du <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/Budget/Compte[(./@NumCompte=$codeBoucleEtat) and (./@NumCompte=$codeBoucleEtat)]/@DateActualisation)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p><p align="center" style="text-align:center"><span style="font-size:11.0pt"> </span></p></td></tr>
               <tr><td width="50%" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1"><p><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@CodeBC)"/> – <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@Libelle)"/></span></p></td><td width="50%" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Exercice : <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Exercice/@V)"/></span></p></td></tr>
               <xsl:choose><xsl:when test="$docbudg/EnteteComptable/Infos/Collectivite/@TypeBC = 'BA' or $docbudg/EnteteComptable/Infos/Collectivite/@TypeBC = 'BR'"><xsl:variable name="varOdm2" select="$varOdm1"/><tr><td width="50%" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1"><p><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">BA de <span style="color:black; background:fuchsia"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/BudgetRattachement/@Libelle)"/>                      </span></span></p></td><td width="50%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1"> </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="50%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="50%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td></tr></xsl:otherwise></xsl:choose>
            </thead><tr><td width="100%" colspan="2" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p style="punctuation-wrap:simple;word-break:break-all"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Balance d’entrée : <xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/Budget/Compte[(./@NumCompte=$codeBoucleEtat)]/@MtBE"/></xsl:call-template></span></p><p style="punctuation-wrap:simple;word-break:break-all"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Débits de l’exercice : <xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/Budget/Compte[(./@NumCompte=$codeBoucleEtat)]/@MtDebit"/></xsl:call-template></span></p><p style="punctuation-wrap:simple;word-break:break-all"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Crédits de l’exercice : <xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/Budget/Compte[(./@NumCompte=$codeBoucleEtat)]/@MtCredit"/></xsl:call-template></span></p><p><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Solde de l’exercice : <xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/Budget/Compte[(./@NumCompte=$codeBoucleEtat)]/@MtSolde"/></xsl:call-template></span></p></td></tr><tr><td width="100%" colspan="2" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0cm 0cm 0cm 0cm" rowspan="1">
                  <div align="center">
                     <xsl:variable name="varOdmTmpTab3"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse"><thead>
                           <tr height="0" class="#tech# #fixWidths#"><td width="10%" style="border:none" rowspan="1" colspan="1"></td><td width="35%" style="border:none" rowspan="1" colspan="1"></td><td width="35%" style="border:none" rowspan="1" colspan="1"></td><td width="20%" style="border:none" rowspan="1" colspan="1"></td></tr>
                           <tr><xsl:variable name="varOdm3" select="$varOdm1"/><xsl:variable name="content155">
                                 <b><span></span></b>
                              </xsl:variable><xsl:variable name="className326">LIGNE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className326" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content155" /></xsl:call-template><xsl:variable name="content156"> </xsl:variable><xsl:variable name="className327">LIGNE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className327" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">35%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content156" /></xsl:call-template><xsl:variable name="content157"> </xsl:variable><xsl:variable name="className328">LIGNE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className328" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">35%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content157" /></xsl:call-template><xsl:variable name="content158"> </xsl:variable><xsl:variable name="className329">LIGNE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className329" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">20%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content158" /></xsl:call-template></tr>
                           <tr style="height:25.5pt"><xsl:variable name="varOdm4" select="$varOdm1"/><xsl:variable name="content159">
                                 <b><span>Date de l’écriture</span></b>
                              </xsl:variable><xsl:variable name="className330">VBORDER</xsl:variable><xsl:variable name="className331">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className330, ' ', $className331)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content159" /></xsl:call-template><xsl:variable name="content160">
                                 <b><span>Références des pièces</span></b>
                              </xsl:variable><xsl:variable name="className332">VBORDER</xsl:variable><xsl:variable name="className333">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className332, ' ', $className333)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">35%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content160" /></xsl:call-template><xsl:variable name="content161">
                                 <b><span>Libellé</span></b>
                              </xsl:variable><xsl:variable name="className334">VBORDER</xsl:variable><xsl:variable name="className335">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className334, ' ', $className335)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">35%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content161" /></xsl:call-template><xsl:variable name="content162">Solde au <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/Budget/Compte[(./@NumCompte=$codeBoucleEtat)]/@DateArrete)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></xsl:variable><xsl:variable name="className336">VBORDER</xsl:variable><xsl:variable name="className337">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className336, ' ', $className337)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">20%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content162" /></xsl:call-template></tr>
                        </thead><xsl:variable name="varOdm5" select="$varOdm1"/><xsl:variable name="varOdm6"><xsl:for-each select="$varOdm5"><xsl:sort select="./@NumOrdre" data-type="number"/><xsl:variable name="ligne" select="."/><tr><xsl:variable name="content163"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($ligne/@DateEcriture)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></xsl:variable><xsl:variable name="className338" select="$ligne/@Format"/><xsl:variable name="className339">LIBELLE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className338, ' ', $className339)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content163" /></xsl:call-template><xsl:variable name="content164"><xsl:value-of select="distinct-values($ligne/@ReferencePiece)"/> <xsl:value-of select="distinct-values($ligne/@NumPiece)"/></xsl:variable><xsl:variable name="className340" select="$ligne/@Format"/><xsl:variable name="className341">LIBELLE</xsl:variable><xsl:variable name="className342">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className340, ' ', $className341, ' ', $className342)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">35%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content164" /></xsl:call-template><xsl:variable name="content165"><xsl:value-of select="distinct-values($ligne/@NomRS)"/> <xsl:value-of select="distinct-values($ligne/@IdentifiantReglement)"/></xsl:variable><xsl:variable name="className343" select="$ligne/@Format"/><xsl:variable name="className344">LIBELLE</xsl:variable><xsl:variable name="className345">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className343, ' ', $className344, ' ', $className345)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">35%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content165" /></xsl:call-template><xsl:variable name="content166"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/@MtSolde"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className346" select="$ligne/@Format"/><xsl:variable name="className347">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className346, ' ', $className347)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">20%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content166" /></xsl:call-template></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm7"><xsl:choose><xsl:when test="count($varOdm6/*) = 0"><tr class=" #tech#" style="height:25.5pt"><td height="1px" width="10%" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:1.4pt 1.4pt 1.4pt 1.4pt;"></td><td height="1px" width="35%" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:1.4pt 1.4pt 1.4pt 1.4pt;"></td><td height="1px" width="35%" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:1.4pt 1.4pt 1.4pt 1.4pt;"></td><td height="1px" width="20%" rowspan="1" colspan="1" style="border-top:hidden;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:1.4pt 1.4pt 1.4pt 1.4pt;"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm6"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowStyled"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm7/xhtml:tr"></xsl:with-param></xsl:call-template><tr style="height:42.5pt"><xsl:variable name="varOdm8" select="$varOdm1"/><xsl:variable name="content167"><xsl:value-of select="distinct-values($docbudg/Budget/Compte[(./@NumCompte=$codeBoucleEtat)]/TotalCompte/@Libelle)"/></xsl:variable><xsl:variable name="className348" select="$docbudg/Budget/Compte[(./@NumCompte=$codeBoucleEtat)]/TotalCompte/@Format"/><xsl:variable name="className349">LIBELLE</xsl:variable><xsl:variable name="className350">HBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className348, ' ', $className349, ' ', $className350)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">3</xsl:with-param><xsl:with-param name="width">35%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content167" /></xsl:call-template><xsl:variable name="content168"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/Budget/Compte[(./@NumCompte=$codeBoucleEtat)]/TotalCompte/@MtSolde"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className351" select="$docbudg/Budget/Compte[(./@NumCompte=$codeBoucleEtat)]/@Format"/><xsl:variable name="className352">DECIMAL</xsl:variable><xsl:variable name="className353">HBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className351, ' ', $className352, ' ', $className353)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">20%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content168" /></xsl:call-template></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab3"></xsl:with-param></xsl:call-template>
                  </div>
               </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"> </p>
      </div>
   </xsl:for-each></xsl:otherwise></xsl:choose></body><script type="text/javascript">
            function iframeLoadPage(href) {
            try {
            parent.loadPage(href);
            } catch(ex) {
            //si on n'arrive pas a acceder a la page parente
            document.location.href = href;
            }
            }
            function scrollToElementId(elementId) {
            document.getElementById(elementId).scrollIntoView();
            }
        </script>
</html></xsl:template></xsl:stylesheet>